=begin
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
# Designed September 2009 by Fredo6

# Permission to use this software for any purpose and without fee is hereby granted
# Distribution of this software for commercial purpose is subject to:
#  - the expressed, written consent of the author
#  - the inclusion of the present copyright notice in all copies.

# THIS SOFTWARE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR
# IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
#-----------------------------------------------------------------------------
# Name			:   CurviloftAlong.rb
# Original Date	:   4 Jan 2010 - version 1.0
# Description	:   Specific method for AlongPath methods in the Curviloft script family
#-------------------------------------------------------------------------------------------------------------------------------------------------
#*************************************************************************************************
=end

module Curviloft

class CVL_LoftAlgo 

#----------------------------------------------------------------------------
# ALONG: analysis of Contours
#----------------------------------------------------------------------------

#Verify contours for Skin
def along_check_contours(lst_contours, from_selection=false)

	#only the rail is defined
	return false if lst_contours.length == 1
	
	#Computing the plates
	lplates = lst_contours.collect { |lpt| plate_create(lpt) }
	lplates.each { |plate| plate_compute_plane plate }
	
	#Testing Rail against other contours
	lpl = lplates.clone
	irail = 0
	lpl.delete_at irail
	@rail = lplates[irail].pts
	lordered = along_test_rail lplates[irail].pts, lpl
	#puts "lorederd = #{lordered.inspect}"
	if lordered.length == 0
		lordered = [0, 1]
		lordered = lordered.reverse if lpl[0].pts[0].distance(@rail[0]) > lpl[1].pts[0].distance(@rail[0])
		plate1 = lpl[lordered[0]]
		plate2 = lpl[lordered[1]]
		plate1.vecrail = @rail[0].vector_to @rail[1]
		plate2.vecrail = @rail[-2].vector_to @rail[-1]
	end	
	
	@lst_plates = lordered.collect { |i| lpl[i] }
		
	#puts "rail = #{@rail.length}"
	#puts "plate 0 = #{@lst_plates[0].pts.length} - index = #{@lst_plates[0].rail_index} "
	#puts "plate 1 = #{@lst_plates[1].pts.length} - index = #{@lst_plates[1].rail_index}"
	
	#Creating Plates and Links
	n = @lst_plates.length
	
	#Case there is only one plate - Replicate the other one
	if n == 1
		along_replicate_rail
		
	#Several plates
	else
		for i in 0..n-2
			j = (i+1).modulo(n)
			link_create @lst_plates[i], @lst_plates[j]
			#puts "create link #{i} - #{j}"
		end	
		#p = @lst_plates[1].pts
		#@lst_plates[1].pts = p[1..3] + p[0..1]
	end
	
	#Checking the intersection of rails with plates
	along_chop_rail
	
	#Creating the borders for highlight
	@lst_links.each do |link|
		link.hiborders = link.plates.collect { |plate| plate.pts + ((plate.loop) ? [plate.pts[0]] : []) }
	end

	true
end

def along_replicate_rail
	plate1 = @lst_plates[0]
	bary = plate1.bary
	@rail = @rail.reverse if bary.distance(@rail[0]) > bary.distance(@rail[-1])
	pts2 = []
	plate1.pts.each do |pt|
		lpt = G6.curl_offset_at_point(@rail, pt)
		pts2.push lpt[-1]
	end
	pts2.push pts2.first if plate1.loop
	plate2 = plate_create pts2
	@lst_plates.push plate2
	plate_compute_plane plate2
	#plate1.vecrail = @rail[0].vector_to @rail[1]
	plate2.vecrail = @rail[-2].vector_to @rail[-1]
	#plate2.vecrail = plate2.vecrail.reverse
	link_create plate1, plate2
end

def along_test_rail(rail, lplates)
	#puts "lplates = #{lplates.length}"
	n = rail.length - 1
	hplates_treated = {}
	lordered = []
	for i in 1..n
		pt1 = rail[i-1]
		pt2 = rail[i]
		along_intersect_all_plates i, pt1, pt2, lplates, hplates_treated, lordered
	end
	lordered
end

def along_intersect_all_plates(ipt, pt1, pt2, lplates, hplates_treated, lordered)
	vec = pt1.vector_to pt2
	ldist = []
	lplates.each_with_index do |plate, iplate|
		next if hplates_treated[iplate]
		d, ptinter = along_intersect_segment_plate pt1, pt2, plate
		ldist.push [d, iplate, ptinter] if d
	end
	#puts "LDIST = #{ldist.length}"
	ldist.sort! { |a, b| a[0] <=> b[0] }
	ldist.each do |ll|
		iplate = ll[1]
		lordered.push iplate
		lplates[iplate].vecrail = vec 
		lplates[iplate].rail_inter = ll[2] 
		lplates[iplate].rail_index = ipt 
		hplates_treated[iplate] = true
	end	
end

def along_intersect_segment_plate(pt1, pt2, plate)
	ptinter = plate.pts.find { |pt| pt == pt1 || pt == pt2 }
	return [pt1.distance(ptinter), ptinter] if ptinter
	return []
	if plate.plane
		ptinter = intersect_segment_plane pt1, pt2, plate.plane
	else
		line = [plate.pts[0], plate.pts[-1]]
		ptinter = G6.intersect_segment_line pt1, pt2, line
	end
	(ptinter) ? [pt1.distance(ptinter), ptinter] : []
end

#Check if a segment [pt1, pt2] crosses a given plane
def intersect_segment_plane(pt1, pt2, plane)
	return pt1 if pt1.on_plane?(plane)
	return pt2 if pt2.on_plane?(plane)
	pt = Geom.intersect_line_plane [pt1, pt2], plane
	(pt && (pt.vector_to(pt1) % pt.vector_to(pt2) < 0)) ? pt : nil
end

#Comute the slices of rail between each plate (needed for Stretch sub-method)
def along_chop_rail
	@lst_links.each do |link|
		plate1 = link.plates[0]
		plate2 = link.plates[1]
		ipt1 = plate1.rail_index
		ipt2 = plate2.rail_index
		next unless ipt2
		ptinter1 = plate1.rail_inter
		ptinter2 = plate2.rail_inter
		rail = [ptinter1]
		#ipt1 += 1 if @rail[ipt1] == ptinter1
		#ipt2 -= 1 if @rail[ipt2] == ptinter2
		for i in ipt1..ipt2
			rail.push @rail[i]
		end
		link.rail = rail
	end
end

#Construct the Along_path curves for a link
def along_junction_construct(link)	
	offsetting = @hprop[:option_offset]
	norm = 
	lbz_pts = []
	link.rail = @rail unless link.rail
	
	link.pairs.each do |pair|
		pt1 = pair[0].pt
		pt2 = pair[1].pt
		#if link.biloop #&& false
		if offsetting
			#puts "offset method"
			normal = @hprop[:offset_normal]
			bz = G6.curl_offset_by_two_points @rail, pt1, pt2, normal
		else	
			bz = G6.curl_move_extremities link.rail, pt1, pt2
		end	
		#puts "Junction curl = #{bz.inspect}" if (bz.find_all { |a| a =  nil }).length > 0
		lbz_pts.push bz
	end
	#puts "\n==================================\n"
	for i in 0..link.rail.length-1
		#puts "\nrail = #{link.rail[i]}"
		#puts "bz   = #{lbz_pts.last[i]}"
	end	
	lbz_pts
end

end	#End Class CVL_LoftAlgo

end	#End Module Curviloft
